/*
 * Decompiled with CFR 0.152.
 */
package com.superliminal.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class ComponentDependencyHandler
implements ActionListener,
ItemListener,
PropertyChangeListener,
FocusListener,
KeyListener {
    private static Class[] listener_classes = new Class[]{ActionListener.class, ItemListener.class, PropertyChangeListener.class, FocusListener.class, KeyListener.class};

    public ComponentDependencyHandler() {
    }

    public ComponentDependencyHandler(Component d1) {
        this(new Component[]{d1});
    }

    public ComponentDependencyHandler(Component d1, Component d2) {
        this(new Component[]{d1, d2});
    }

    public ComponentDependencyHandler(Component d1, Component d2, Component d3) {
        this(new Component[]{d1, d2, d3});
    }

    public ComponentDependencyHandler(Component d1, Component d2, Component d3, Component d4) {
        this(new Component[]{d1, d2, d3, d4});
    }

    public ComponentDependencyHandler(Component d1, Component d2, Component d3, Component d4, Component d5) {
        this(new Component[]{d1, d2, d3, d3, d5});
    }

    public ComponentDependencyHandler(Component[] dependents) {
        this.adddependents(dependents);
    }

    public void adddependents(Component[] dependents) {
        int i = 0;
        while (i < dependents.length) {
            Component comp = dependents[i];
            int j = 0;
            while (j < listener_classes.length) {
                this.tryToAddListener(comp, listener_classes[j]);
                ++j;
            }
            ++i;
        }
    }

    public abstract void dependencyNotification();

    private void tryToAddListener(Component comp, Class listener_class) {
        String listener_name = listener_class.getName();
        int last_dot = listener_name.lastIndexOf(".");
        listener_name = listener_name.substring(last_dot + 1);
        try {
            Method adder = comp.getClass().getMethod("add" + listener_name, listener_class);
            adder.invoke((Object)comp, this);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.dependencyNotification();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.dependencyNotification();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.dependencyNotification();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.dependencyNotification();
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.dependencyNotification();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.dependencyNotification();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.dependencyNotification();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.dependencyNotification();
    }
}

