/*
 * Decompiled with CFR 0.152.
 */
package com.superliminal.charts;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipClassLoader
extends ClassLoader {
    private Hashtable cachedClasses = new Hashtable();
    private Vector applicationPackages;
    private byte[] zipFileBytes;
    private byte[] classByteBuffer;

    public ZipClassLoader(byte[] zipFileBytes, Vector applicationPackages) throws IOException {
        this.zipFileBytes = zipFileBytes;
        this.applicationPackages = applicationPackages;
        ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(zipFileBytes));
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        int maxEntrySize = 0;
        while (zipEntry != null) {
            zipInputStream.closeEntry();
            int zipEntrySize = (int)zipEntry.getSize();
            maxEntrySize = zipEntrySize > maxEntrySize ? zipEntrySize : maxEntrySize;
            zipEntry = zipInputStream.getNextEntry();
        }
        zipInputStream.close();
        this.classByteBuffer = new byte[++maxEntrySize];
    }

    public synchronized Class loadClass(String className, boolean resolveIt) throws ClassNotFoundException {
        byte[] classBytes;
        Class<?> resultClass = (Class<?>)this.cachedClasses.get(className);
        if (resultClass != null) {
            return resultClass;
        }
        boolean isApplicationClass = false;
        Enumeration packages = this.applicationPackages.elements();
        while (packages.hasMoreElements() && !isApplicationClass) {
            String applicationPackage = (String)packages.nextElement();
            isApplicationClass = className.startsWith(applicationPackage);
        }
        if (!isApplicationClass) {
            try {
                resultClass = super.findSystemClass(className);
                return resultClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if ((classBytes = this.loadFileBytes(className)) == null) {
            throw new ClassNotFoundException();
        }
        resultClass = this.defineClass(className, classBytes, 0, classBytes.length);
        if (resultClass == null) {
            throw new ClassFormatError();
        }
        if (resolveIt) {
            this.resolveClass(resultClass);
        }
        this.cachedClasses.put(className, resultClass);
        return resultClass;
    }

    private byte[] loadFileBytes(String className) {
        ZipInputStream zipInputStream;
        block6: {
            String searchZipEntryName = String.valueOf(className.replace('.', '/')) + ".class";
            zipInputStream = new ZipInputStream(new ByteArrayInputStream(this.zipFileBytes));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null && !zipEntry.getName().equals(searchZipEntryName)) {
                zipEntry = zipInputStream.getNextEntry();
            }
            if (zipEntry != null) break block6;
            return null;
        }
        try {
            int totalBytesRead = 0;
            int bytesReadThisTime = 0;
            while (bytesReadThisTime != -1) {
                bytesReadThisTime = zipInputStream.read(this.classByteBuffer, totalBytesRead, this.classByteBuffer.length - totalBytesRead);
                if (bytesReadThisTime == -1) continue;
                totalBytesRead += bytesReadThisTime;
            }
            zipInputStream.close();
            byte[] classBytes = new byte[totalBytesRead];
            int i = 0;
            while (i < totalBytesRead) {
                classBytes[i] = this.classByteBuffer[i];
                ++i;
            }
            return classBytes;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

