/*
 * Decompiled with CFR 0.152.
 */
package com.superliminal.charts;

import com.superliminal.charts.QuoteSource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;

public class YahooQuotes
implements QuoteSource {
    private static final int MAX_CLOSES = 2000;
    private float[] closes = new float[2000];
    private String last_close = null;
    private int[] splits = new int[5];
    private int[] monthstarts = new int[66];
    private int ncloses = 0;
    private int nmonthstarts = 0;
    private String symbol = null;
    private static final String[] month_names = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    private boolean fuzzyEquals(float a, float b, float tol) {
        float absdiff;
        float diff = a - b;
        float f = absdiff = diff < 0.0f ? -diff : diff;
        return absdiff < tol;
    }

    private float checkSplit(float close, float prev) {
        float[] types = new float[]{2.0f, 1.5f, 3.0f, 4.0f, 0.5f, 0.6666667f};
        if (this.fuzzyEquals(close, 0.0f, 1.0E-5f) || this.fuzzyEquals(prev, 0.0f, 1.0E-5f)) {
            return 1.0f;
        }
        int i = 0;
        while (i < types.length) {
            if (this.fuzzyEquals(close * types[i], prev, close / 5.0f)) {
                return types[i];
            }
            ++i;
        }
        return 1.0f;
    }

    private int monthNum(String name) {
        int i = 0;
        while (i < 12) {
            if (name.equalsIgnoreCase(month_names[i])) {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public boolean initSymbol(String sym, int n_desired_days_back) {
        String str;
        boolean found_values;
        BufferedReader reader;
        block14: {
            InputStream is;
            URL page;
            Calendar start = Calendar.getInstance();
            start.add(6, -n_desired_days_back);
            int day = start.get(5);
            int month = start.get(2) + 1;
            int year = start.get(1);
            this.symbol = sym;
            try {
                String urlstr = "http://ichart.yahoo.com/table.csv?&a=" + month + "&b=" + day + "&c=" + year + "&s=" + this.symbol;
                page = new URL(urlstr);
            }
            catch (MalformedURLException mue) {
                return false;
            }
            try {
                is = page.openStream();
            }
            catch (IOException ieo) {
                ieo.printStackTrace();
                return false;
            }
            reader = new BufferedReader(new InputStreamReader(is));
            found_values = false;
            str = reader.readLine();
            if (str != null && str.startsWith("Date,")) break block14;
            return false;
        }
        try {
            found_values = true;
            this.ncloses = 0;
            this.nmonthstarts = 1;
            String curmonstr = null;
            float splitfactor = 1.0f;
            int i = 0;
            while (i < n_desired_days_back) {
                str = reader.readLine();
                if (str == null || str.startsWith("<")) break;
                String closestr = str.split(",")[4];
                if (this.ncloses == 0) {
                    this.last_close = closestr;
                }
                float closeval = Float.valueOf(closestr).floatValue();
                float splitadjustedcloseval = closeval * splitfactor;
                if (i > 0) {
                    float f = this.checkSplit(this.closes[i - 1], splitadjustedcloseval);
                }
                this.closes[this.ncloses++] = closeval *= splitfactor;
                int monstart = str.indexOf(45);
                String monstr = str.substring(monstart + 1, monstart + 3);
                if (curmonstr == null) {
                    curmonstr = monstr;
                } else if (!monstr.equalsIgnoreCase(curmonstr)) {
                    curmonstr = monstr;
                    this.monthstarts[this.nmonthstarts] = i;
                    ++this.nmonthstarts;
                }
                ++i;
            }
            if (curmonstr != null) {
                this.monthstarts[0] = Integer.parseInt(curmonstr);
            }
        }
        catch (IOException ioe) {
            return false;
        }
        return found_values;
    }

    @Override
    public String getName() {
        return this.symbol;
    }

    @Override
    public float getCurrentPrice() {
        if (this.ncloses == 0) {
            return 0.0f;
        }
        return this.closes[0];
    }

    @Override
    public float[] getCloses() {
        float[] vals = new float[this.ncloses];
        int i = 0;
        while (i < this.ncloses) {
            vals[i] = this.closes[i];
            ++i;
        }
        return vals;
    }

    @Override
    public int[] getMonthStarts() {
        int[] vals = new int[this.nmonthstarts];
        if (this.nmonthstarts > 0) {
            vals[0] = this.monthstarts[0];
        }
        int i = 1;
        while (i < this.nmonthstarts) {
            vals[i] = this.monthstarts[i];
            ++i;
        }
        return vals;
    }
}

