/*
 * Decompiled with CFR 0.152.
 */
package com.superliminal.charts;

import com.superliminal.charts.SortingProps;
import com.superliminal.util.ComponentDependencyHandler;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;

public class SymbolListEditor
extends Dialog {
    private SortingProps m_symbols;
    private SortingProps m_curSymbols = null;
    private List m_list = new List();

    private void prepareToShow() {
        this.m_curSymbols = (SortingProps)this.m_symbols.clone();
        this.updateList();
    }

    @Override
    public void setVisible(boolean vis) {
        if (vis) {
            this.prepareToShow();
        }
        super.setVisible(vis);
    }

    @Override
    public void show() {
        this.prepareToShow();
        super.show();
    }

    public SymbolListEditor(SortingProps symbols, Frame f) {
        super(f);
        this.setTitle("Symbol List Editor");
        this.setSize(500, 300);
        this.m_symbols = symbols;
        this.setLayout(new BorderLayout());
        this.add("West", this.m_list);
        final TextField watermark = new TextField(6);
        this.m_list.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    watermark.setText(SymbolListEditor.this.m_curSymbols.get(SymbolListEditor.this.m_list.getItem(SymbolListEditor.this.m_list.getSelectedIndex())));
                }
            }
        });
        Panel control_panel = new Panel(new GridLayout(4, 1));
        Panel row = new Panel();
        row.add(new Label("Purchace Price:"));
        row.add(watermark);
        final Button set_button = new Button("Set");
        set_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SymbolListEditor.this.m_curSymbols.put(SymbolListEditor.this.m_list.getItem(SymbolListEditor.this.m_list.getSelectedIndex()), watermark.getText());
            }
        });
        row.add(set_button);
        control_panel.add(row);
        row = new Panel();
        row.add(new Label("New Symbol:"));
        final TextField newsym = new TextField(6);
        row.add(newsym);
        row.add(new Label("price:"));
        final TextField newprice = new TextField(6);
        row.add(newprice);
        final Button add_button = new Button("Add");
        add_button.setEnabled(false);
        add_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SymbolListEditor.this.m_curSymbols.put(newsym.getText().toUpperCase(), newprice.getText());
                SymbolListEditor.this.updateList();
                newsym.setText(null);
                newprice.setText(null);
                add_button.setEnabled(false);
                watermark.setText(null);
                set_button.setEnabled(false);
            }
        });
        row.add(add_button);
        control_panel.add(row);
        row = new Panel();
        final Button delete_button = new Button("Delete");
        delete_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int selected_id = SymbolListEditor.this.m_list.getSelectedIndex();
                SymbolListEditor.this.m_curSymbols.remove(SymbolListEditor.this.m_list.getItem(selected_id));
                SymbolListEditor.this.updateList();
                delete_button.setEnabled(false);
                watermark.setText(null);
                set_button.setEnabled(false);
            }
        });
        delete_button.setEnabled(false);
        row.add(delete_button);
        control_panel.add(row);
        row = new Panel();
        Button ok_button = new Button("OK");
        ok_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SymbolListEditor.this.setVisible(false);
                SymbolListEditor.this.m_symbols.clear();
                Enumeration<Object> e = SymbolListEditor.this.m_curSymbols.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    SymbolListEditor.this.m_symbols.put(key, SymbolListEditor.this.m_curSymbols.get(key));
                }
            }
        });
        row.add(ok_button);
        Button cancel_button = new Button("Cancel");
        cancel_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SymbolListEditor.this.m_list.deselect(SymbolListEditor.this.m_list.getSelectedIndex());
                watermark.setText(null);
                set_button.setEnabled(false);
                SymbolListEditor.this.setVisible(false);
            }
        });
        row.add(cancel_button);
        control_panel.add(row);
        new ComponentDependencyHandler((Component)watermark, (Component)this.m_list){

            @Override
            public void dependencyNotification() {
                set_button.setEnabled(SymbolListEditor.this.m_list.getSelectedIndex() >= 0 && watermark.getText().length() > 0);
            }
        };
        new ComponentDependencyHandler((Component)newsym){

            @Override
            public void dependencyNotification() {
                add_button.setEnabled(newsym.getText().length() > 0);
            }
        };
        new ComponentDependencyHandler((Component)this.m_list){

            @Override
            public void dependencyNotification() {
                delete_button.setEnabled(SymbolListEditor.this.m_list.getSelectedIndex() >= 0);
                if (SymbolListEditor.this.m_list.getSelectedIndex() < 0) {
                    newsym.setText(null);
                }
            }
        };
        this.add("Center", control_panel);
    }

    private void updateList() {
        SortingProps symbols = this.m_curSymbols;
        if (symbols == null) {
            symbols = this.m_symbols;
        }
        String[] sorted = symbols.getSortedKeys();
        this.m_list.removeAll();
        int i = 0;
        while (i < sorted.length) {
            this.m_list.add(sorted[i]);
            ++i;
        }
    }
}

