/*
 * Decompiled with CFR 0.152.
 */
package com.superliminal.charts;

import com.superliminal.charts.ArrowButton;
import com.superliminal.charts.ChartArea;
import com.superliminal.charts.LabeledTypein;
import com.superliminal.charts.ProxyDialog;
import com.superliminal.charts.QuoteSource;
import com.superliminal.charts.SortingProps;
import com.superliminal.charts.SymbolListEditor;
import com.superliminal.charts.YahooQuotes;
import java.awt.Button;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class StockCharts
extends Frame {
    private static final String PROP_FILE = "chartprops.txt";
    private static final String SYMBOLS_FILE = "symbols.txt";
    private static final String SYMBOL_PROMPT = "symbol";
    private static final int DEFAULT_MOVING_AVERAGE_DAYS = 30;
    private static final int DEFAULT_DESIRED_DAYS_BACK = 300;
    private static final int SCROLL_THUMB_WIDTH = 20;
    private ChartArea m_chart_area = new ChartArea();
    private Label m_lastPrice = null;
    private LabeledTypein m_closesTypein = new LabeledTypein("Days Back:", "300");
    private TextField m_symbolTypeinText;
    private PopupMenu m_symbolChooser = new PopupMenu();
    private Label m_moving_average_label = new Label("30");
    private Properties m_chartProps = null;
    private SortingProps m_symbols = this.loadSymbols();
    private SymbolListEditor m_symbol_editor = new SymbolListEditor(this.m_symbols, this);
    private QuoteSource[] m_sources = new QuoteSource[]{new YahooQuotes()};
    private Scrollbar m_aveScroller = new Scrollbar(0, 30, 20, 1, 220){

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(200, 20);
        }
    };
    private QuoteSource m_quoteSource;

    public StockCharts(String symbol) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ((Window)e.getSource()).dispose();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                StockCharts.this.quit();
            }
        });
        this.setSize(600, 400);
        this.initProps();
        MenuBar menubar = new MenuBar();
        this.setMenuBar(menubar);
        Menu filemenu = new Menu("File");
        menubar.add(filemenu);
        filemenu.add(new MenuItem("Quit")).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                StockCharts.this.quit();
            }
        });
        Menu editmenu = new Menu("Edit");
        menubar.add(editmenu);
        editmenu.add(new MenuItem("Symbols...")).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                StockCharts.this.m_symbol_editor.setVisible(true);
            }
        });
        Menu settingsmenu = new Menu("Settings");
        menubar.add(settingsmenu);
        final StockCharts this_frame = this;
        settingsmenu.add(new MenuItem("Set Proxy")).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ProxyDialog pd = new ProxyDialog(this_frame);
                pd.setModal(true);
                pd.setVisible(true);
                if (pd.hasData()) {
                    StockCharts.this.m_chartProps.put("proxy.host", pd.getHost());
                    StockCharts.this.m_chartProps.put("proxy.port", pd.getPort());
                    StockCharts.this.initProps();
                }
            }
        });
        settingsmenu.add(new MenuItem("Clear Proxy")).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                StockCharts.this.m_chartProps.remove("proxy.host");
                StockCharts.this.m_chartProps.remove("proxy.port");
                StockCharts.this.initProps();
            }
        });
        this.add(this.m_chart_area);
        this.setTitle("Stock Charts by Melinda Green - Superliminal Software");
        this.setSymbol(symbol);
        LabeledTypein symboltypein = new LabeledTypein("Ticker:", symbol == null ? SYMBOL_PROMPT : symbol);
        this.m_symbolTypeinText = symboltypein.getTextField();
        KeyAdapter do_it_adapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    StockCharts.this.setSymbol(StockCharts.this.m_symbolTypeinText.getText());
                    StockCharts.this.m_symbolTypeinText.selectAll();
                }
            }
        };
        this.m_symbolTypeinText.setEditable(true);
        this.m_symbolTypeinText.selectAll();
        this.m_symbolTypeinText.addKeyListener(do_it_adapter);
        Panel control_panel = new Panel(new FlowLayout());
        control_panel.add(symboltypein);
        final ArrowButton chooser_launcher = new ArrowButton();
        control_panel.add(chooser_launcher);
        control_panel.add(this.m_symbolChooser);
        chooser_launcher.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StockCharts.this.refreshSymbolChooser();
                StockCharts.this.m_symbolChooser.show(chooser_launcher, 0, 0);
            }
        });
        this.m_closesTypein.getTextField().addKeyListener(do_it_adapter);
        control_panel.add(this.m_closesTypein);
        Button eb = new Button("Enter"){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                StockCharts.this.m_symbolTypeinText.selectAll();
            }
        };
        eb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StockCharts.this.setSymbol(StockCharts.this.m_symbolTypeinText.getText());
                StockCharts.this.m_symbolTypeinText.selectAll();
            }
        });
        this.m_aveScroller.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                int madays = e.getValue();
                StockCharts.this.setMovingAverageDays(madays);
            }
        });
        control_panel.add(new Label("Moving Average Days: "));
        control_panel.add(this.m_moving_average_label);
        control_panel.add(this.m_aveScroller);
        this.m_lastPrice = new Label("                               ");
        control_panel.add(this.m_lastPrice);
        this.add("South", control_panel);
    }

    private void refreshSymbolChooser() {
        this.m_symbolChooser.removeAll();
        String[] symbols = this.m_symbols.getSortedKeys();
        int i = 0;
        while (i < symbols.length) {
            final String name = symbols[i];
            MenuItem item = new MenuItem(name);
            this.m_symbolChooser.add(item);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    StockCharts.this.m_symbolTypeinText.setText(name);
                    StockCharts.this.m_symbolTypeinText.selectAll();
                    StockCharts.this.setSymbol(name);
                }
            });
            ++i;
        }
        this.m_symbolChooser.addSeparator();
        final String current = this.m_symbolTypeinText.getText();
        final boolean unique_symbol = current != null && current.length() > 0 && this.m_symbols.get(current) == null && !current.equalsIgnoreCase(SYMBOL_PROMPT);
        MenuItem watcher = new MenuItem("Watch");
        watcher.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (unique_symbol) {
                    StockCharts.this.m_symbols.put(current.toUpperCase(), "");
                }
            }
        });
        watcher.setEnabled(unique_symbol);
        this.m_symbolChooser.add(watcher);
        this.m_symbolChooser.add(new MenuItem("Edit...")).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                StockCharts.this.m_symbol_editor.setVisible(true);
            }
        });
    }

    private int getDesiredDays(String str) {
        try {
            int days = Integer.parseInt(str);
            if (days > 0) {
                return days;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 300;
    }

    private void quit() {
        FileOutputStream out2;
        if (this.m_chartProps == null) {
            return;
        }
        this.m_chartProps.put("width", Integer.toString(this.getSize().width));
        this.m_chartProps.put("height", Integer.toString(this.getSize().height));
        this.m_chartProps.put("daysback", this.m_closesTypein.getTextField().getText());
        try {
            out2 = new FileOutputStream(PROP_FILE);
            this.m_chartProps.save(out2, "---Stock Chart Properties---");
            out2.close();
        }
        catch (IOException out2) {
            // empty catch block
        }
        try {
            out2 = new FileOutputStream(SYMBOLS_FILE);
            this.m_symbols.save(out2, "---Stock Chart Symbols---");
            out2.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.exit(0);
    }

    private SortingProps loadSymbols() {
        SortingProps symbols = new SortingProps();
        try {
            FileInputStream in = new FileInputStream(SYMBOLS_FILE);
            symbols.load(in);
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return symbols;
    }

    private void initProps() {
        String desired_moving_average_days_string;
        int dc;
        String desired_days_back;
        if (this.m_chartProps == null) {
            this.m_chartProps = new Properties();
            try {
                FileInputStream in = new FileInputStream(PROP_FILE);
                this.m_chartProps.load(in);
                in.close();
                int width = new Integer(this.m_chartProps.getProperty("width", "600"));
                int height = new Integer(this.m_chartProps.getProperty("height", "400"));
                this.setSize(width, height);
            }
            catch (Exception in) {
                // empty catch block
            }
        }
        if (this.m_chartProps.get("proxy.host") != null) {
            System.getProperties().put("proxyHost", this.m_chartProps.get("proxy.host"));
            System.getProperties().put("proxySet", "true");
            if (this.m_chartProps.get("proxy.port") != null) {
                System.getProperties().put("proxyPort", this.m_chartProps.get("proxy.port"));
            }
        } else {
            this.m_chartProps.remove("proxySet");
            this.m_chartProps.remove("proxyHost");
            this.m_chartProps.remove("proxyPort");
            System.getProperties().remove("proxySet");
            System.getProperties().remove("proxyHost");
            System.getProperties().remove("proxyPort");
        }
        if ((desired_days_back = (String)this.m_chartProps.get("daysback")) != null && (dc = Integer.parseInt(desired_days_back)) > 0) {
            this.m_closesTypein.getTextField().setText(desired_days_back);
        }
        if ((desired_moving_average_days_string = (String)this.m_chartProps.get("movingaveragedays")) != null) {
            int desired_moving_average_days = 30;
            try {
                desired_moving_average_days = Integer.parseInt(desired_moving_average_days_string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setMovingAverageDays(desired_moving_average_days);
            this.m_aveScroller.setValue(desired_moving_average_days);
        }
    }

    public void setSymbol(final String symbol) {
        if (symbol != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    StockCharts.this.setCursor(Cursor.getPredefinedCursor(3));
                    int i = 0;
                    while (i < StockCharts.this.m_sources.length) {
                        if (StockCharts.this.m_sources[i].initSymbol(symbol, StockCharts.this.getDesiredDays(StockCharts.this.m_closesTypein.getText()))) {
                            StockCharts.this.setMovingAverageDays(StockCharts.this.m_aveScroller.getValue(), StockCharts.this.m_sources[i].getCloses().length);
                            StockCharts.this.m_chart_area.setSource(StockCharts.this.m_sources[i], StockCharts.this.m_aveScroller.getValue(), StockCharts.this.m_symbols.get(symbol.toUpperCase()));
                            StockCharts.this.m_lastPrice.setText("Last Close: $" + StockCharts.this.m_sources[i].getCurrentPrice());
                            break;
                        }
                        ++i;
                    }
                    StockCharts.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }).start();
        }
    }

    private void setMovingAverageDays(int madays, int totaldays) {
        int value;
        int visible;
        if (madays > totaldays) {
            madays = totaldays;
        }
        if ((visible = totaldays / 10) < 1) {
            visible = 1;
        }
        if ((value = this.m_aveScroller.getValue()) > totaldays) {
            value = totaldays;
        }
        this.m_aveScroller.setValues(value, visible, 1, totaldays + visible);
        this.m_chartProps.put("movingaveragedays", String.valueOf(madays));
        this.m_moving_average_label.setText(String.valueOf(madays));
        this.m_chart_area.setMovingAverage(madays);
    }

    private void setMovingAverageDays(int madays) {
        int cur_max = Integer.parseInt(this.m_closesTypein.getTextField().getText());
        this.setMovingAverageDays(madays, cur_max);
    }

    public static void main(String[] args) {
        StockCharts cht = new StockCharts(args.length > 0 ? args[0] : null);
        cht.setVisible(true);
    }
}

