/*
 * Decompiled with CFR 0.152.
 */
package com.superliminal.charts;

import com.superliminal.charts.ChartUtils;
import com.superliminal.charts.QuoteSource;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

class ChartArea
extends Canvas {
    private int m_movingAverageDays;
    private String m_boughtAt = null;
    private Font labelfont = new Font("Dialog", 0, 12);
    private Font symbolfont = new Font("Dialog", 1, 18);
    private QuoteSource m_quoteSource;
    private static final String[] month_names = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    ChartArea() {
    }

    public void setSource(QuoteSource source, int moving_average_days, String boughtat) {
        this.m_quoteSource = source;
        this.m_movingAverageDays = moving_average_days;
        this.m_boughtAt = boughtat;
        this.repaint();
    }

    public void setMovingAverage(int moving_average_days) {
        this.setSource(this.m_quoteSource, moving_average_days, this.m_boughtAt);
    }

    private String monthName(String num) {
        int which = Integer.valueOf(num);
        return month_names[which - 1];
    }

    private void drawWideLine(Graphics g, float fxs, float fys, float fxe, float fye) {
        int xs = (int)((double)fxs + 0.5);
        int ys = (int)((double)fys + 0.5);
        int xe = (int)((double)fxe + 0.5);
        int ye = (int)((double)fye + 0.5);
        g.drawLine(xs, ys, xe, ye);
        int dx = Math.abs(xe - xs);
        int dy = Math.abs(ye - ys);
        if (dx > dy) {
            int offset = fys < (float)ys ? -1 : 1;
            g.drawLine(xs, ys + 1, xe, ye + 1);
        } else {
            int offset = fxs < (float)xs ? -1 : 1;
            g.drawLine(xs + 1, ys, xe + 1, ye);
        }
        g.setColor(Color.black);
    }

    private static float max(float[] vals) {
        float maxval = 0.0f;
        int i = 0;
        while (i < vals.length) {
            if (vals[i] > maxval) {
                maxval = vals[i];
            }
            ++i;
        }
        return maxval;
    }

    @Override
    public void paint(Graphics gr) {
        if (this.m_quoteSource == null) {
            return;
        }
        int h = this.getSize().height;
        int w = this.getSize().width;
        float[] closes = this.m_quoteSource.getCloses();
        if (closes == null || closes.length == 0) {
            return;
        }
        float pixperclose = (float)w / (float)(closes.length - 1);
        float maxclose = ChartArea.max(closes);
        float bought_val = 0.0f;
        try {
            bought_val = Float.valueOf(this.m_boughtAt).floatValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ChartUtils.ChartSteps dolarstep = ChartUtils.calcSteps(Math.max(maxclose, bought_val));
        int high_round_price = dolarstep.stepCount * dolarstep.stepSize;
        float pixperdolar = (float)h / (float)high_round_price;
        Graphics g = gr;
        g.setFont(this.labelfont);
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        if (this.m_boughtAt != null && this.m_boughtAt.length() != 0) {
            float boughtval = Float.valueOf(this.m_boughtAt).floatValue();
            g.setColor(new Color(0.8f, 0.8f, 1.0f));
            int waterline = (int)((double)((float)h - boughtval * pixperdolar) + 0.5);
            if (waterline < 0) {
                waterline = 0;
            }
            g.fillRect(0, waterline, w, h);
        }
        g.setColor(Color.cyan.darker());
        int threecharwidth = g.getFontMetrics().stringWidth("May");
        int indent = (int)(3.0f * pixperclose);
        boolean use_month_names = false;
        if (20.0f * pixperclose > (float)(threecharwidth + 2 * indent)) {
            use_month_names = true;
        }
        int[] monthstarts = this.m_quoteSource.getMonthStarts();
        int firstmonthid = monthstarts[0] - 1;
        int i = 1;
        while (i < monthstarts.length) {
            int monthx = (int)((double)((float)monthstarts[i] * pixperclose) + 0.5 + 0.5);
            g.drawLine(monthx, 0, monthx, h);
            int monthid = (firstmonthid + i) % 12;
            String label = use_month_names ? month_names[monthid] : "" + (monthid + 1);
            g.drawString(label, monthx + indent, h - 2);
            ++i;
        }
        int firstmonthline = monthstarts.length < 2 ? 0 : (int)((double)((float)monthstarts[1] * pixperclose) + 0.5 + 0.5);
        int fontheight = g.getFontMetrics().getHeight();
        if (monthstarts.length > 0) {
            g.drawLine(0, h - 1, w, h - 1);
            int i2 = 1;
            while (i2 <= dolarstep.stepCount) {
                float line = (float)(i2 * dolarstep.stepSize) * pixperdolar;
                int dolary = h - (int)((double)line + 0.5);
                g.drawLine(0, dolary, w, dolary);
                int labelx = firstmonthline > threecharwidth ? 1 : firstmonthline + 1;
                g.drawString("$" + Integer.toString(i2 * dolarstep.stepSize), labelx, dolary + fontheight);
                if (dolarstep.stepCount < 5) {
                    float half_line = line - (float)dolarstep.stepSize * pixperdolar / 2.0f;
                    this.drawDashedHorizontalLine(g, 0, w, (int)((double)half_line + 0.5));
                }
                ++i2;
            }
        }
        g.setColor(Color.black);
        g.setFont(this.symbolfont);
        String symbol = this.m_quoteSource.getName();
        int symbol_width = g.getFontMetrics().stringWidth(symbol);
        g.drawString(symbol, w / 2 - symbol_width / 2, g.getFontMetrics().getAscent() + 8);
        int i3 = 0;
        while (i3 < closes.length - 1) {
            int xs = w - (int)((float)i3 * pixperclose);
            int ys = h - (int)((double)(closes[i3] * pixperdolar) + 0.5);
            int xe = w - (int)((float)(i3 + 1) * pixperclose);
            int ye = h - (int)((double)(closes[i3 + 1] * pixperdolar) + 0.5);
            g.drawLine(xs, ys + 1, xe, ye + 1);
            g.drawLine(xs, ys, xe, ye);
            ++i3;
        }
        float sum = 0.0f;
        float startoffset = ((float)this.m_movingAverageDays / 2.0f - 0.5f) * pixperclose;
        if (closes.length > this.m_movingAverageDays) {
            int i4 = 0;
            while (i4 < this.m_movingAverageDays) {
                sum += closes[i4];
                ++i4;
            }
        }
        float ave = sum / (float)this.m_movingAverageDays;
        int i5 = 0;
        while (i5 + this.m_movingAverageDays < closes.length) {
            g.setColor(Color.red);
            sum = sum - closes[i5] + closes[i5 + this.m_movingAverageDays];
            float nextave = sum / (float)this.m_movingAverageDays;
            g.drawLine(w - (int)((double)(startoffset + (float)i5 * pixperclose) + 0.5), h - (int)((double)(ave * pixperdolar) + 0.5), w - (int)((double)(startoffset + (float)(i5 + 1) * pixperclose) + 0.5), h - (int)((double)(nextave * pixperdolar) + 0.5));
            ave = nextave;
            ++i5;
        }
    }

    private void drawDashedHorizontalLine(Graphics g, int xstart, int xend, int y) {
        int x = xstart;
        while (x < xend) {
            g.drawLine(x, y, x + 4, y);
            x += 10;
        }
    }
}

